/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWInstructionElement;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.manager.IVWChunkableQuery;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.IVWStepProcessorComponent;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Beans;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWMilestonesTableModel
extends AbstractTableModel
implements IVWTableOperation,
IVWChunkableQuery {
    private static final int NUM_COLUMNS = 3;
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_LAUNCH_DATE = 1;
    private static final int COLUMN_SUBJECT = 2;
    private static final Long NO_DATE = new Long("-2000000000000");
    private static final Long NO_TIMER = new Long("2147483647000");
    private static final Long NO_TIME = new Long("0");
    private VWSession m_vwSession = null;
    private Container m_parentContainer = null;
    private Frame m_parentFrame = null;
    private DateFormat m_dateTimeFormatter = null;
    private Icon m_workflowIcon = null;
    private Vector m_rowCache = new Vector();
    private Font m_plainFont = null;
    private Font m_titleFont = null;
    private int m_nMaxRowsToDisplay = 50;
    private int m_numResults = 0;
    private boolean m_bAllRostersHaveMinMilestoneExposed = true;
    private boolean m_bCanPerformNext = false;
    private Object[] m_rosterQueries = null;
    private int m_nCurrentRosterIndex = 0;

    public VWMilestonesTableModel(VWSession vwSession, Container parentContainer, JApplet parentApplet) {
        try {
            this.m_vwSession = vwSession;
            this.m_parentContainer = parentContainer;
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(parentContainer);
            this.m_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);
            this.loadIcons();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex, VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int index) {
        if (index == 0) {
            return Icon.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return " ";
            }
            case 1: {
                return VWResource.s_launchedOn;
            }
            case 2: {
                return VWResource.s_subject;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        try {
            VWRosterElement rosterElement = (VWRosterElement)this.m_rowCache.elementAt(rowIndex);
            if (rosterElement != null) {
                switch (columnIndex) {
                    case 0: {
                        return this.m_workflowIcon;
                    }
                    case 1: {
                        Date fieldValue = rosterElement.getLaunchDate();
                        if (fieldValue == null || NO_TIME.longValue() == fieldValue.getTime() || NO_TIMER.longValue() == fieldValue.getTime() || NO_DATE.longValue() == fieldValue.getTime()) break;
                        return this.m_dateTimeFormatter.format(fieldValue);
                    }
                    case 2: {
                        if (!rosterElement.hasFieldName("F_Subject")) break;
                        return rosterElement.getSubject();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openItem(int rowIndex) {
        try {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            VWRosterElement selectedRosterElement = (VWRosterElement)this.m_rowCache.elementAt(rowIndex);
            VWProcess process = this.fetchProcess(selectedRosterElement);
            if (process != null) {
                VWMilestoneElement[] milestoneElements = process.fetchFilteredWorkflowMilestones(1, true, true);
                if (milestoneElements != null && milestoneElements.length > 0) {
                    JComponent milestonePanel = (JComponent)Beans.instantiate(this.getClass().getClassLoader(), "filenet.vw.toolkit.runtime.step.beans.VWMilestonePanel");
                    if (milestonePanel != null) {
                        Font font;
                        Dimension dim;
                        VWWorkObject workObject;
                        if (milestonePanel instanceof IVWStepProcessorComponent && (workObject = selectedRosterElement.fetchWorkObject(false, false)) != null) {
                            ((IVWStepProcessorComponent)((Object)milestonePanel)).init(workObject.fetchStepElement(), null, this.m_vwSession);
                        }
                        if ((dim = VWStringUtils.stringToDimension(VWResource.s_milestonesDialogDim)) != null) {
                            milestonePanel.setPreferredSize(dim);
                        } else {
                            milestonePanel.setPreferredSize(new Dimension(500, 300));
                        }
                        JPanel milestoneSummaryPanel = new JPanel();
                        if ((this.m_plainFont == null || this.m_titleFont == null) && (font = milestoneSummaryPanel.getFont()) != null) {
                            this.m_plainFont = new Font(font.getName(), 0, font.getSize());
                            this.m_titleFont = new Font(font.getName(), 1, font.getSize() + 5);
                        }
                        milestoneSummaryPanel.setLayout(new BorderLayout(5, 5));
                        milestoneSummaryPanel.add((Component)this.getMilestoneSummaryHeaderPanel(rowIndex), "First");
                        milestoneSummaryPanel.add((Component)milestonePanel, "Last");
                        JOptionPane.showMessageDialog(this.m_parentFrame, milestoneSummaryPanel, VWResource.s_milestones, -1);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noMilestones, VWResource.s_milestones, 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void refresh() {
        this.m_rowCache.removeAllElements();
        this.performQuery();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public boolean getCanPerformNext() {
        return this.m_bCanPerformNext;
    }

    public void setMaxRowsDisplayed(int maxRows) {
        this.m_nMaxRowsToDisplay = maxRows;
    }

    public int getMaxRowsDisplayed() {
        return this.m_nMaxRowsToDisplay;
    }

    public boolean getHasElements() {
        return false;
    }

    public void performNext() {
        this.m_rowCache.removeAllElements();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public int getQueryResultsCount() {
        return this.m_numResults;
    }

    private void performQuery() {
        String currentUserName = null;
        int currentUserId = 0;
        String[] rosterNames = null;
        Vector<VWRosterQuery> rosterVector = null;
        VWRoster vwRoster = null;
        VWRosterQuery vwRosterQuery = null;
        VWRosterDefinition vwRosterDef = null;
        try {
            if (this.m_vwSession == null) {
                return;
            }
            currentUserName = this.m_vwSession.fetchCurrentUserInfo().getName();
            currentUserId = this.m_vwSession.convertUserNameToId(currentUserName);
            rosterVector = new Vector<VWRosterQuery>();
            this.m_numResults = 0;
            this.m_nCurrentRosterIndex = 0;
            rosterNames = this.m_vwSession.fetchRosterNames(false);
            for (int i = 0; i < rosterNames.length; ++i) {
                vwRoster = this.m_vwSession.getRoster(rosterNames[i]);
                if (vwRoster == null) continue;
                vwRosterDef = vwRoster.fetchRosterDefinition();
                if (vwRosterDef != null && vwRosterDef.hasFieldName("F_Originator")) {
                    String queryFilter = null;
                    if (vwRosterDef.hasFieldName("F_MinMilestone")) {
                        queryFilter = "F_Originator=" + Integer.toString(currentUserId) + " AND F_MinMilestone=1";
                    } else {
                        queryFilter = "F_Originator=" + Integer.toString(currentUserId);
                        this.m_bAllRostersHaveMinMilestoneExposed = false;
                    }
                    vwRosterQuery = vwRoster.createQuery(null, null, null, 0, queryFilter, null, 4);
                    rosterVector.add(vwRosterQuery);
                    this.m_numResults += vwRosterQuery.fetchCount();
                    continue;
                }
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_missingOriginatorError.toString(rosterNames[i]), VWResource.s_errorRetrievingMilestoneInformation, 0);
            }
            this.m_rosterQueries = rosterVector.toArray();
            this.retrieveRowData();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    private void retrieveRowData() {
        VWRosterElement curElement = null;
        try {
            if (this.m_rosterQueries == null || this.m_rosterQueries.length < 1) {
                return;
            }
            while (curElement == null && this.m_nCurrentRosterIndex < this.m_rosterQueries.length) {
                curElement = (VWRosterElement)((VWRosterQuery)this.m_rosterQueries[this.m_nCurrentRosterIndex]).next();
                if (curElement != null) continue;
                ++this.m_nCurrentRosterIndex;
            }
            int nRowCount = 0;
            while (curElement != null && nRowCount < this.m_nMaxRowsToDisplay) {
                if (this.m_bAllRostersHaveMinMilestoneExposed || curElement.hasFieldName("F_MinMilestone")) {
                    Object fieldValue = null;
                    if (!this.m_bAllRostersHaveMinMilestoneExposed) {
                        fieldValue = curElement.getFieldValue("F_MinMilestone");
                    }
                    if ((this.m_bAllRostersHaveMinMilestoneExposed || fieldValue != null && fieldValue instanceof Integer && (Integer)fieldValue == 1) && !this.alreadyInList(curElement)) {
                        ++nRowCount;
                        int insertAt = this.findSortedPositionInList(curElement);
                        this.m_rowCache.insertElementAt(curElement, insertAt);
                    }
                }
                if (nRowCount >= this.m_nMaxRowsToDisplay) continue;
                curElement = (VWRosterElement)((VWRosterQuery)this.m_rosterQueries[this.m_nCurrentRosterIndex]).next();
                while (curElement == null && this.m_nCurrentRosterIndex < this.m_rosterQueries.length) {
                    curElement = (VWRosterElement)((VWRosterQuery)this.m_rosterQueries[this.m_nCurrentRosterIndex]).next();
                    if (curElement != null) continue;
                    ++this.m_nCurrentRosterIndex;
                }
            }
            this.m_bCanPerformNext = this.m_nCurrentRosterIndex < this.m_rosterQueries.length && ((VWRosterQuery)this.m_rosterQueries[this.m_nCurrentRosterIndex]).hasNext();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            VWDebug.logException(ex);
        }
    }

    private boolean alreadyInList(VWRosterElement rosterElement) {
        try {
            for (int i = 0; i < this.m_rowCache.size(); ++i) {
                VWRosterElement tempRE = (VWRosterElement)this.m_rowCache.elementAt(i);
                if (tempRE == null || tempRE.getWorkflowNumber().compareTo(rosterElement.getWorkflowNumber()) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private int findSortedPositionInList(VWRosterElement rosterElement) {
        int nIndex = -1;
        try {
            Date newdate = rosterElement.getLaunchDate();
            for (nIndex = 0; nIndex < this.m_rowCache.size(); ++nIndex) {
                VWRosterElement tempRE = (VWRosterElement)this.m_rowCache.elementAt(nIndex);
                if (tempRE == null || newdate.compareTo(tempRE.getLaunchDate()) > 0) continue;
                return nIndex;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nIndex;
    }

    private void loadIcons() {
        try {
            this.m_workflowIcon = VWImageLoader.createImageIcon("milestone.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWProcess fetchProcess(VWRosterElement rosterElement) {
        try {
            int nWorkClassId = 0;
            if (rosterElement.hasFieldName("F_WorkClassId")) {
                nWorkClassId = (Integer)rosterElement.getFieldValue("F_WorkClassId");
            } else if (rosterElement.hasFieldName("*F_WorkClassId")) {
                nWorkClassId = (Integer)rosterElement.getFieldValue("*F_WorkClassId");
            }
            int nWorkSpaceId = -1;
            if (rosterElement.hasFieldName("F_WorkSpaceId")) {
                nWorkSpaceId = (Integer)rosterElement.getFieldValue("F_WorkSpaceId");
            } else if (rosterElement.hasFieldName("*F_WorkSpaceId")) {
                nWorkSpaceId = (Integer)rosterElement.getFieldValue("*F_WorkSpaceId");
            } else {
                VWWorkflowDefinition wflDef = this.m_vwSession.fetchWorkflowDefinition(nWorkSpaceId, this.m_vwSession.convertIdToClassName(nWorkClassId, false), false);
                if (wflDef != null) {
                    nWorkSpaceId = wflDef.getRuntimeId().getWorkSpaceId();
                } else {
                    VWInstructionElement instructionElement = rosterElement.fetchInstructionElement(false, false);
                    if (instructionElement != null) {
                        if (instructionElement.hasFieldName("F_WorkSpaceId")) {
                            nWorkSpaceId = (Integer)instructionElement.getFieldValue("F_WorkSpaceId");
                        } else if (instructionElement.hasFieldName("*F_WorkSpaceId")) {
                            nWorkSpaceId = (Integer)instructionElement.getFieldValue("*F_WorkSpaceId");
                        }
                    }
                }
            }
            return this.m_vwSession.fetchProcess(nWorkSpaceId, nWorkClassId, rosterElement.getWorkflowNumber());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMilestoneSummaryHeaderPanel(int nRowIndex) throws Exception {
        JPanel titlePanel = new JPanel(new BorderLayout(5, 5));
        JPanel title = new JPanel();
        JLabel newLabel = new JLabel(VWResource.s_milestoneSummary);
        if (this.m_titleFont != null) {
            newLabel.setFont(this.m_titleFont);
        }
        title.add(newLabel);
        titlePanel.add((Component)title, "First");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridwidth = -1;
        gbConst.gridheight = 1;
        gbConst.anchor = 23;
        gbConst.fill = 0;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 4, 4, 4);
        infoPanel.add((Component)new JLabel(VWResource.s_subjectColon), gbConst);
        gbConst.gridwidth = 0;
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        newLabel = new JLabel((String)this.getValueAt(nRowIndex, 2));
        if (this.m_plainFont != null) {
            newLabel.setFont(this.m_plainFont);
        }
        infoPanel.add((Component)newLabel, gbConst);
        gbConst.gridwidth = -1;
        gbConst.fill = 0;
        gbConst.weightx = 0.0;
        infoPanel.add((Component)new JLabel(VWResource.s_launchedOnColon), gbConst);
        gbConst.gridwidth = 0;
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        newLabel = new JLabel((String)this.getValueAt(nRowIndex, 1));
        if (this.m_plainFont != null) {
            newLabel.setFont(this.m_plainFont);
        }
        infoPanel.add((Component)newLabel, gbConst);
        titlePanel.add((Component)infoPanel, "Center");
        return titlePanel;
    }
}

